#ifdef VFLIB

#include	"defs.h"
#include	"emit.h"
#include	"global.h"
#include	"bifont.h"
#include	"rastfont.h"
#include	"ps.h"
#include	"VF.h"

static struct pd pd;

dev_vflo_begfontdict()
{
    initpd(pd);
}

void
dev_vflo_initfontdict(fe, vflfi, k, c, tw, w, h, d, outline)
struct font_entry *fe;
struct vflfntinfo *vflfi;
int k, c;
int tw, w, h, d;
long *outline;
{
    struct vflchar_entry *ce;
    int bw;

    end_string();

    ce = vflfi->ch+k;
    /* open font dict before first char */
    if (getpd(&pd))
	EMIT(outfp, "%.3f %d /%s NF2\n",
	     1.0, NPACKPSCHARS, psfname(pd.pd_font));
#ifdef STATS
    if (fe->ncdl == -1)
	fe->ncdl = 0;
#endif
    ce->dev_font = pd.pd_font;
    ce->dev_char = pd.pd_char;
    dev_setfont(ce->dev_font);

#ifdef DEBUG
    if (Debug)
	EMIT(outfp, "%% font: %s char: %x\n", fe->n, c);
#endif
    bw = (w+7)>>3;
    EMITC('[');
    pscharoutline(w, h, outline);
    EMIT(outfp, "\n%d %d %d %d %.3f] %d D\n", 
	 bw<<3, h,
	 0, d, ((float)tw)/hconv,
	 /*ce->xoffset, (((int)ce->height)-ce->yoffset)-1, cw/cf,*/
	 ce->dev_char);
}

/* The following function pscharoutline is written by Ein Terakawa. */

#define	TOKEN_INITIAL	0
#define	TOKEN_LINE	1
#define	TOKEN_BEZ	2
#define	ConvX(x)	((VFD_GET_X(x)-OUTLINE_OFFSET))
#define	ConvY(x)	((OUTLINE_SIZE-(VFD_GET_Y(x)-OUTLINE_OFFSET)))

#define	checklen(l)	\
	{cc += l; \
	 if (cc > 67) {EMITC('\n'); cc = 0;} \
	 else EMITC(' ');}
#define	emitdata(x,y,i)	{EMIT(outfp, "%d %d %c", (x), (y), i); checklen(12);}
#define	emitdata0(x,y)	{EMIT(outfp, "%d %d", (x), (y)); checklen(10);}

pscharoutline(int w, int h, long *outline)
{
    long *ptr;
    int token;
    int cmd, dat;
    int cc;
    int initialx, initialy;
    
    EMITC('{');
    EMIT(outfp, "%.3f %.3f scale\n",
	 (float)w/OUTLINE_SIZE, (float)h/OUTLINE_SIZE);
    ptr = &outline[2];
    token = TOKEN_INITIAL;
    cc = 0;
    
    while (*ptr != 0) {
	if (*ptr&VFD_TOKEN) {
	    cmd = *ptr++;
	    dat = *ptr++;;
	    if ((cmd&VFD_CWCURV) == VFD_CWCURV ||
		(cmd&VFD_CCWCURV) == VFD_CCWCURV) {
		if (token != TOKEN_INITIAL) {
		    if (token == TOKEN_BEZ) {
			emitdata(initialx, initialy, 'c');
		    }
		    EMITS("closepath\n");
		    cc = 0;
		}
		emitdata(ConvX(dat), ConvY(dat), 'p');
		initialx = ConvX(dat);
		initialy = ConvY(dat);
	    } else if (token == TOKEN_BEZ) {
		emitdata(ConvX(dat), ConvY(dat), 'c');
	    } else {
		emitdata(ConvX(dat), ConvY(dat), 'l');
	    }
	    if ((cmd&VFD_BEZ) == VFD_BEZ)
		token = TOKEN_BEZ;
	    else if ((cmd&VFD_LINE) == VFD_LINE)
		token = TOKEN_LINE;
	} else {
	    dat = *ptr++;
	    if (token == TOKEN_BEZ) {
		emitdata(ConvX(dat), ConvY(dat), 'c');
	    } else {
		emitdata(ConvX(dat), ConvY(dat), 'l');
	    }
	}
	if (token == TOKEN_BEZ) {
	    dat = *ptr++;
	    emitdata0(ConvX(dat), ConvY(dat));
	    dat = *ptr++;
	    emitdata0(ConvX(dat), ConvY(dat));
	}
    }
    if (token == TOKEN_BEZ) {
	emitdata(initialx, initialy, 'c');
    }
    EMITS("closepath eofill}");
    
    /*
    if(outline[0] & 1)
	EMIT(outfp, "{0 0 p %d %d l %d 0 p 0 %d l 20 setlinewidth stroke}",
	     w,h,w,h);
    else
	EMIT(outfp, "{0 %d p 0 %d %d 0 %d 0 c %d 0 %d %d %d %d c %d %d %d %d %d %d c %d %d 0 %d 0 %d c closepath fill}",
	     h/2,h/4,w/4,w/2,w*3/4,w,h/4,w,h/2,
	     w,h*3/4,w*3/4,h,w/2,h,w/4,h,h*3/4,h/2);
     */
    return 0;
}

#endif
