#include <errno.h>
#include <sys/doscalls.h>
#include "djio.h"

READFUNC _console_read = 0;

int _read (int handle, void *buf, unsigned nbyte)
{
    int count, ret_bytes, dos_bytes;

    if (_files[handle] & F_DEV) {   /* DEV_CON (also DEV_CLK, DEV_NUL) */
	if (_console_read)
	    return _console_read (handle, buf, nbyte);
	else {
	    errno = EINVAL;
	    return -1;
	}
    }

    /* dos/windows can't read more than 64K */
    count = nbyte;
    while (count > 0) {
	dos_bytes = (count <= 0xFFF0) ? count : 0xFFF0;
	ret_bytes = dos_read (handle, buf, dos_bytes);
	count -= ret_bytes;
	if (ret_bytes < dos_bytes)
	    break;
	buf += ret_bytes;
    }
    return (nbyte - count);
}
