/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType4;
import org.apache.pdfbox.pdmodel.graphics.shading.Type4ShadingContext;
import org.apache.pdfbox.util.Matrix;

public class Type4ShadingPaint
implements Paint {
    private static final Log LOG = LogFactory.getLog(Type4ShadingPaint.class);
    private PDShadingType4 shading;
    private Matrix ctm;
    private int pageHeight;

    public Type4ShadingPaint(PDShadingType4 shading, Matrix ctm, int pageHeight) {
        this.shading = shading;
        this.ctm = ctm;
        this.pageHeight = pageHeight;
    }

    @Override
    public int getTransparency() {
        return 0;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        try {
            return new Type4ShadingContext(this.shading, cm, xform, this.ctm, this.pageHeight, deviceBounds);
        }
        catch (IOException ex) {
            LOG.error(ex);
            return null;
        }
    }
}

